using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace SPStudio
{
	/// <summary>
	/// The main window of the application and acts as
	/// mdi parent to all other windows.
	/// </summary>
	public class Desktop : System.Windows.Forms.Form
	{
		#region Private Vars
		/// <summary>
		/// Handle to the active workspace
		/// within the desktop.
		/// </summary>
		private Workspace workspace = null;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.MainMenu MainMenu;
		private System.Windows.Forms.MenuItem FileMenu;
		private System.Windows.Forms.MenuItem NewWkspcFileItem;
		private System.Windows.Forms.MenuItem OpenWkspcFileItem;
		private System.Windows.Forms.MenuItem SaveWkspcFileItem;
		private System.Windows.Forms.MenuItem LoadMdlFileItem;
		private System.Windows.Forms.MenuItem ImageMenu;
		private System.Windows.Forms.MenuItem AddImageImageItem;
		private System.Windows.Forms.MenuItem ViewMenu;
		private System.Windows.Forms.MenuItem CloseWkspcFileItem;
		private System.Windows.Forms.MenuItem RunAlgMenu;
		private System.Windows.Forms.MenuItem ShiftMenu;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Standard constructor that initializes components.
		/// </summary>
		public Desktop()
		{
			InitializeComponent();
		}
		#endregion

		#region Dispose Operation
		/// <summary>
		/// Clean up any resources being used.
		/// Inform current open workspace that the 
		/// application is closing so all 
		/// resources can be properly disposed.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (workspace!=null) workspace.closing = true;

				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.MainMenu = new System.Windows.Forms.MainMenu();
			this.FileMenu = new System.Windows.Forms.MenuItem();
			this.NewWkspcFileItem = new System.Windows.Forms.MenuItem();
			this.OpenWkspcFileItem = new System.Windows.Forms.MenuItem();
			this.SaveWkspcFileItem = new System.Windows.Forms.MenuItem();
			this.LoadMdlFileItem = new System.Windows.Forms.MenuItem();
			this.CloseWkspcFileItem = new System.Windows.Forms.MenuItem();
			this.ImageMenu = new System.Windows.Forms.MenuItem();
			this.AddImageImageItem = new System.Windows.Forms.MenuItem();
			this.ViewMenu = new System.Windows.Forms.MenuItem();
			this.RunAlgMenu = new System.Windows.Forms.MenuItem();
			this.ShiftMenu = new System.Windows.Forms.MenuItem();
			// 
			// MainMenu
			// 
			this.MainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.FileMenu,
																					 this.ImageMenu,
																					 this.ViewMenu,
																					 this.RunAlgMenu,
																					 this.ShiftMenu});
			// 
			// FileMenu
			// 
			this.FileMenu.Index = 0;
			this.FileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.NewWkspcFileItem,
																					 this.OpenWkspcFileItem,
																					 this.SaveWkspcFileItem,
																					 this.LoadMdlFileItem,
																					 this.CloseWkspcFileItem});
			this.FileMenu.Text = "File";
			// 
			// NewWkspcFileItem
			// 
			this.NewWkspcFileItem.Index = 0;
			this.NewWkspcFileItem.Text = "New Workspace";
			this.NewWkspcFileItem.Click += new System.EventHandler(this.NewWkspcFileItem_Click);
			// 
			// OpenWkspcFileItem
			// 
			this.OpenWkspcFileItem.Index = 1;
			this.OpenWkspcFileItem.Text = "Open Workspace";
			this.OpenWkspcFileItem.Click += new System.EventHandler(this.OpenWkspcFileItem_Click);
			// 
			// SaveWkspcFileItem
			// 
			this.SaveWkspcFileItem.Enabled = false;
			this.SaveWkspcFileItem.Index = 2;
			this.SaveWkspcFileItem.Text = "Save Workspace";
			this.SaveWkspcFileItem.Click += new System.EventHandler(this.SaveWkspcFileItem_Click);
			// 
			// LoadMdlFileItem
			// 
			this.LoadMdlFileItem.Enabled = false;
			this.LoadMdlFileItem.Index = 3;
			this.LoadMdlFileItem.Text = "Load Model";
			this.LoadMdlFileItem.Click += new System.EventHandler(this.LoadMdlFileItem_Click);
			// 
			// CloseWkspcFileItem
			// 
			this.CloseWkspcFileItem.Enabled = false;
			this.CloseWkspcFileItem.Index = 4;
			this.CloseWkspcFileItem.Text = "Close Workspace";
			this.CloseWkspcFileItem.Click += new System.EventHandler(this.CloseWkspcFileItem_Click);
			// 
			// ImageMenu
			// 
			this.ImageMenu.Enabled = false;
			this.ImageMenu.Index = 1;
			this.ImageMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.AddImageImageItem});
			this.ImageMenu.Text = "Image";
			// 
			// AddImageImageItem
			// 
			this.AddImageImageItem.Index = 0;
			this.AddImageImageItem.Text = "Add Image";
			this.AddImageImageItem.Click += new System.EventHandler(this.AddImageImageItem_Click);
			// 
			// ViewMenu
			// 
			this.ViewMenu.Enabled = false;
			this.ViewMenu.Index = 2;
			this.ViewMenu.Text = "View";
			this.ViewMenu.Click += new System.EventHandler(this.ViewMenu_Click);
			// 
			// RunAlgMenu
			// 
			this.RunAlgMenu.Enabled = false;
			this.RunAlgMenu.Index = 3;
			this.RunAlgMenu.Text = "Run Algorithm";
			this.RunAlgMenu.Click += new System.EventHandler(this.RunAlgMenu_Click);
			// 
			// ShiftMenu
			// 
			this.ShiftMenu.Enabled = false;
			this.ShiftMenu.Index = 4;
			this.ShiftMenu.Text = "Shift";
			this.ShiftMenu.Click += new System.EventHandler(this.ShiftMenu_Click);
			// 
			// Desktop
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 166);
			this.IsMdiContainer = true;
			this.Menu = this.MainMenu;
			this.Name = "Desktop";
			this.Text = "SPStudio";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;

		}
		#endregion

		#region Main()
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Desktop());
		}
		#endregion

		#region Reset Desktop Menu
		/// <summary>
		/// Return the desktop menus
		/// to their default enabled
		/// states.
		/// </summary>
		public void reset()
		{
			toggleCloseWkspc(false);
			toggleViewMenu(false);
			toggleSaveWkspc(false);
			toggleAddImage(false);
			toggleRunAlgMenu(false);
			toggleShiftMenu(false);
			toggleLoadModelMenu(false);
		}

		#endregion
		
		#region Menu Item Handlers
		/// <summary>
		/// Attempt to create a new workspace for the
		/// desktop.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewWkspcFileItem_Click(object sender, System.EventArgs e)
		{
			Workspace tempWorkspace = new Workspace(this);

			if(tempWorkspace.creationCanceled)
			{
				//Dispose of the temporary workspace.
				tempWorkspace.close();
			}
			else
			{
				//It is possible for a new workspace to 
				//be created when there is still an
				//active workspace opened.
				//If so, then close the active
				//and replace it with the new.
				if(workspace!=null)
					workspace.close();
				workspace = tempWorkspace;
			}
		}

		/// <summary>
		/// Add a new image to the workspace
		/// through a call to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddImageImageItem_Click(object sender, System.EventArgs e)
		{
			workspace.addImage();		
		}

		/// <summary>
		/// Activate the list box window containing all
		/// images within the workspace
		/// through a call to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ViewMenu_Click(object sender, System.EventArgs e)
		{
			workspace.viewMenu();
		}

		/// <summary>
		/// Close the active workspace.
		/// Return the desktop to its
		/// initial state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CloseWkspcFileItem_Click(object sender, System.EventArgs e)
		{
			workspace.close();
			workspace = null;
			reset();
		}

		/// <summary>
		/// Run the VRMC algorithm through a call
		/// to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RunAlgMenu_Click(object sender, System.EventArgs e)
		{
			workspace.runAlgorithm();
		}

		/// <summary>
		/// Display the shift view and shift panel
		/// through a call to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ShiftMenu_Click(object sender, System.EventArgs e)
		{
			workspace.activateShift();
		}

		/// <summary>
		/// Save the current workspace
		/// through a call to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SaveWkspcFileItem_Click(object sender, System.EventArgs e)
		{
			workspace.save();
		}

		/// <summary>
		/// Open a saved wks file.
		/// Uses an OpenFileDialog.
		/// If file selection is canceled
		/// DO NOT attempt to replace
		/// the existing workspace.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OpenWkspcFileItem_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog openFileDialog = new OpenFileDialog();
			openFileDialog.InitialDirectory = "Workspaces";
			openFileDialog.Filter = "wks files (*.wks)|*.wks";
			openFileDialog.FilterIndex = 1 ;
			openFileDialog.RestoreDirectory = true ;
			String file = "";
			bool okClicked = false;

			if(openFileDialog.ShowDialog() == DialogResult.OK)
			{				
				okClicked = true;
				file = openFileDialog.FileName.Trim();
				openFileDialog.Dispose();				
			}		
			if(okClicked)
				workspace = new Workspace(this,file);				
		}

		/// <summary>
		/// Save the current finalized voxels
		/// as an mdl file through a call
		/// to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SaveMdlFileItem_Click(object sender, System.EventArgs e)
		{
			workspace.saveMdl();
		}

		/// <summary>
		/// Load an the existing mdl file
		/// associated with this workspace
		/// through a call to a workspace method.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void LoadMdlFileItem_Click(object sender, System.EventArgs e)
		{
			workspace.loadMdl();
		}		
		#endregion

		#region Toggle Enabled Menus
		/// <summary>
		/// Enable or Disable the Load Model menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleLoadModelMenu(bool active)
		{
			LoadMdlFileItem.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the Shift menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleShiftMenu(bool active)
		{
			ShiftMenu.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the Run Algorithm menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleRunAlgMenu(bool active)
		{
			RunAlgMenu.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the Close Workspace menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleCloseWkspc(bool active)
		{
			CloseWkspcFileItem.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the View menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleViewMenu(bool active)
		{
			ViewMenu.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the Save workspace menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleSaveWkspc(bool active)
		{
			SaveWkspcFileItem.Enabled = active;
		}

		/// <summary>
		/// Enable or Disable the Add image menu item.
		/// </summary>
		/// <param name="active"></param>
		public void toggleAddImage(bool active)
		{
			ImageMenu.Enabled = active;
		}
		#endregion

	}
}
